/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.gprinter.command.GpCom;
import com.gprinter.io.BluetoothPort;
import com.gprinter.io.EthernetPort;
import com.gprinter.io.GpPort;
import com.gprinter.io.PortParameters;
import com.gprinter.io.UsbPort;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;

public class GpDevice {
    private static final String DEBUG_TAG = "GpDevice";
    public static final String CONNECT_ERROR = "connect error";
    private BluetoothAdapter mBluetoothAdapter = null;
    private GpPort mPort = null;
    public static final int STATE_NONE = 0;
    public static final int STATE_LISTEN = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    public static final int STATE_INVALID_PRINTER = 4;
    public static final int STATE_VALID_PRINTER = 5;
    public static final int MESSAGE_STATE_CHANGE = 1;
    public static final int MESSAGE_READ = 2;
    public static final int MESSAGE_WRITE = 3;
    public static final int MESSAGE_DEVICE_NAME = 4;
    public static final int MESSAGE_TOAST = 5;
    public static final int MESSAGE_OFFLINE_STATUS = 6;
    public static final String DEVICE_NAME = "device_name";
    public static final String TOAST = "toast";
    public static final String PRINTER_ID = "printer.id";
    public static final String DEVICE_STATUS = "device_status";
    public static final String DEVICE_READ = "device.read";
    public static final String DEVICE_READ_CNT = "device.readcnt";
    private PortParameters mPortParam = new PortParameters();
    private int mCommandType = 0;
    public static Queue<Integer> mReceiveQueue = new LinkedList<Integer>();
    private boolean mReceiveDataEnable = false;

    public void setCommandType(int command) {
        this.mCommandType = command;
    }

    public int getCommandType() {
        return this.mCommandType;
    }

    public PortParameters getPortParameters() {
        return this.mPortParam;
    }

    public void setReceiveDataEnable(boolean b) {
        this.mReceiveDataEnable = b;
    }

    public boolean getReceiveDataEnable() {
        return this.mReceiveDataEnable;
    }

    public int getConnectState() {
        int state = 0;
        if (this.mPort != null) {
            Log.d((String)DEBUG_TAG, (String)"getConnectState ");
            state = this.mPort.getState();
        }
        return state;
    }

    public GpCom.ERROR_CODE openEthernetPort(int id, String ip, int port, Handler mHandler) {
        GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
        this.mPortParam.setPortType(3);
        this.mPortParam.setIpAddr(ip);
        this.mPortParam.setPortNumber(port);
        if (mHandler == null) {
            Log.e((String)DEBUG_TAG, (String)"Parameters is invalid");
            retval = GpCom.ERROR_CODE.INVALID_DEVICE_PARAMETERS;
        } else if (port <= 0) {
            Log.e((String)DEBUG_TAG, (String)"PortNumber is invalid");
            retval = GpCom.ERROR_CODE.INVALID_PORT_NUMBER;
        } else if (ip.length() != 0) {
            try {
                InetAddress.getByName(ip);
                if (this.mPort != null) {
                    if (this.mPort.getState() != 3) {
                        Log.e((String)DEBUG_TAG, (String)"UsbPort is open already, try to closing port");
                        this.mPort.stop();
                        this.mPort = null;
                    } else {
                        return GpCom.ERROR_CODE.DEVICE_ALREADY_OPEN;
                    }
                }
                this.mPort = new EthernetPort(id, ip, port, mHandler);
                this.mPort.connect();
            }
            catch (Exception e) {
                Log.e((String)DEBUG_TAG, (String)"IpAddress is invalid");
                retval = GpCom.ERROR_CODE.INVALID_IP_ADDRESS;
            }
        } else {
            Log.e((String)DEBUG_TAG, (String)"IpAddress is invalid");
            retval = GpCom.ERROR_CODE.INVALID_IP_ADDRESS;
        }
        return retval;
    }

    public GpCom.ERROR_CODE openBluetoothPort(int id, String addr, Handler mHandler) {
        GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
        this.mPortParam.setPortType(4);
        this.mPortParam.setBluetoothAddr(addr);
        if (mHandler == null) {
            Log.e((String)DEBUG_TAG, (String)"Parameters is invalid");
            retval = GpCom.ERROR_CODE.INVALID_DEVICE_PARAMETERS;
        } else {
            this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBluetoothAdapter == null) {
                retval = GpCom.ERROR_CODE.BLUETOOTH_IS_NOT_SUPPORT;
                Log.e((String)DEBUG_TAG, (String)"Bluetooth is not support");
            } else if (!this.mBluetoothAdapter.isEnabled()) {
                retval = GpCom.ERROR_CODE.OPEN_BLUETOOTH;
                Log.e((String)DEBUG_TAG, (String)"Bluetooth is not open");
            } else if (BluetoothAdapter.checkBluetoothAddress((String)addr)) {
                BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(addr);
                if (this.mPort != null) {
                    if (this.mPort.getState() != 3) {
                        Log.e((String)DEBUG_TAG, (String)"Bluetooth is open already, try to closing port");
                        this.mPort.stop();
                        this.mPort = null;
                    } else {
                        return GpCom.ERROR_CODE.DEVICE_ALREADY_OPEN;
                    }
                }
                this.mPort = new BluetoothPort(id, device, mHandler);
                this.mPort.connect();
            } else {
                Log.e((String)DEBUG_TAG, (String)"Bluetooth address is invalid");
                retval = GpCom.ERROR_CODE.INVALID_BLUETOOTH_ADDRESS;
            }
        }
        return retval;
    }

    public GpCom.ERROR_CODE openUSBPort(Context context, int id, String deviceName, Handler handler) {
        GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
        this.mPortParam.setPortType(2);
        this.mPortParam.setUsbDeviceName(deviceName);
        if (handler == null || context == null) {
            retval = GpCom.ERROR_CODE.INVALID_DEVICE_PARAMETERS;
            Log.e((String)DEBUG_TAG, (String)"Parameters is invalid");
        } else {
            if (this.mPort != null) {
                if (this.mPort.getState() != 3) {
                    Log.e((String)DEBUG_TAG, (String)"UsbPort is open already, try to closing port");
                    this.mPort.stop();
                    this.mPort = null;
                } else {
                    return GpCom.ERROR_CODE.DEVICE_ALREADY_OPEN;
                }
            }
            Log.e((String)DEBUG_TAG, (String)("openUSBPort id " + id));
            this.mPort = new UsbPort(context, id, deviceName, handler);
            this.mPort.connect();
        }
        return retval;
    }

    public void closePort() {
        if (this.mPort != null) {
            this.mPort.stop();
            this.mPort = null;
        }
    }

    public GpCom.ERROR_CODE sendDataImmediately(Vector<Byte> Command) {
        GpCom.ERROR_CODE retval;
        Vector<Byte> data = new Vector<Byte>(Command.size());
        if (this.mPort != null) {
            if (this.mPort.getState() == 3) {
                int k = 0;
                while (k < Command.size()) {
                    if (data.size() >= 1024) {
                        retval = this.mPort.writeDataImmediately(data);
                        data.clear();
                        if (retval != GpCom.ERROR_CODE.SUCCESS) {
                            return retval;
                        }
                    }
                    data.add(Command.get(k));
                    ++k;
                }
                retval = this.mPort.writeDataImmediately(data);
                Log.i((String)DEBUG_TAG, (String)("retval = " + (Object)((Object)retval)));
            } else {
                retval = GpCom.ERROR_CODE.PORT_IS_DISCONNECT;
                Log.e((String)DEBUG_TAG, (String)"Port is disconnect");
            }
        } else {
            retval = GpCom.ERROR_CODE.PORT_IS_NOT_OPEN;
            Log.e((String)DEBUG_TAG, (String)"Port is not open");
        }
        return retval;
    }
}

